<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd. M. y',
            'time' => 'H:mm',
            'datetime' => 'd. M. y H:mm',
        ],
        'medium' => [
            'date' => 'd. M. y',
            'time' => 'H:mm:ss',
            'datetime' => 'd. M. y, H:mm:ss',
        ],
        'long' => [
            'date' => 'd. MMMM y',
            'time' => 'H:mm:ss z',
            'datetime' => 'd. MMMM y, H:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE d. MMMM y',
            'time' => 'H:mm:ss zzzz',
            'datetime' => 'EEEE d. MMMM y, H:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0 %',
        'scientific' => '#E0',
    ],
    'amName' => 'AM',
    'pmName' => 'PM',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => ' ',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'e',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ' ',
    ],
    'currencySymbols' => [
        'AUD' => 'AUD ',
        'BRL' => 'BRL ',
        'CAD' => 'CAD ',
        'CNY' => 'CNY ',
        'EUR' => '€',
        'GBP' => 'GBP ',
        'HKD' => 'HKD ',
        'ILS' => 'NIS ',
        'INR' => 'INR ',
        'JPY' => 'JPY ',
        'KRW' => 'KRW ',
        'MXN' => 'MX$',
        'NZD' => 'NZD ',
        'THB' => 'THB ',
        'TWD' => 'TWD ',
        'USD' => 'USD ',
        'VND' => 'VND ',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'j',
            'f',
            'm',
            'a',
            'm',
            'j',
            'j',
            'a',
            's',
            'o',
            'n',
            'd',
        ],
        'medium' => [
            'jan',
            'feb',
            'mar',
            'apr',
            'máj',
            'jún',
            'júl',
            'aug',
            'sep',
            'okt',
            'nov',
            'dec',
        ],
        'full' => [
            'január',
            'február',
            'marec',
            'apríl',
            'máj',
            'jún',
            'júl',
            'august',
            'september',
            'október',
            'november',
            'december',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'j',
            'f',
            'm',
            'a',
            'm',
            'j',
            'j',
            'a',
            's',
            'o',
            'n',
            'd',
        ],
        'medium' => [
            'jan',
            'feb',
            'mar',
            'apr',
            'máj',
            'jún',
            'júl',
            'aug',
            'sep',
            'okt',
            'nov',
            'dec',
        ],
        'full' => [
            'januára',
            'februára',
            'marca',
            'apríla',
            'mája',
            'júna',
            'júla',
            'augusta',
            'septembra',
            'októbra',
            'novembra',
            'decembra',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'n',
            'p',
            'u',
            's',
            'š',
            'p',
            's',
        ],
        'short' => [
            'ne',
            'po',
            'ut',
            'st',
            'št',
            'pi',
            'so',
        ],
        'medium' => [
            'ne',
            'po',
            'ut',
            'st',
            'št',
            'pi',
            'so',
        ],
        'full' => [
            'nedeľa',
            'pondelok',
            'utorok',
            'streda',
            'štvrtok',
            'piatok',
            'sobota',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'n',
            'p',
            'u',
            's',
            'š',
            'p',
            's',
        ],
        'short' => [
            'ne',
            'po',
            'ut',
            'st',
            'št',
            'pi',
            'so',
        ],
        'medium' => [
            'ne',
            'po',
            'ut',
            'st',
            'št',
            'pi',
            'so',
        ],
        'full' => [
            'nedeľa',
            'pondelok',
            'utorok',
            'streda',
            'štvrtok',
            'piatok',
            'sobota',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'afrikánčina',
        'af-NA' => 'afrikánčina (Namíbia)',
        'af-ZA' => 'afrikánčina (Južná Afrika)',
        'agq' => 'aghem',
        'agq-CM' => 'aghem (Kamerun)',
        'ak' => 'akančina',
        'ak-GH' => 'akančina (Ghana)',
        'am' => 'amharčina',
        'am-ET' => 'amharčina (Etiópia)',
        'ar' => 'arabčina',
        'ar-001' => 'arabčina (svet)',
        'ar-AE' => 'arabčina (Spojené arabské emiráty)',
        'ar-BH' => 'arabčina (Bahrajn)',
        'ar-DJ' => 'arabčina (Džibutsko)',
        'ar-DZ' => 'arabčina (Alžírsko)',
        'ar-EG' => 'arabčina (Egypt)',
        'ar-EH' => 'arabčina (Západná Sahara)',
        'ar-ER' => 'arabčina (Eritrea)',
        'ar-IL' => 'arabčina (Izrael)',
        'ar-IQ' => 'arabčina (Irak)',
        'ar-JO' => 'arabčina (Jordánsko)',
        'ar-KM' => 'arabčina (Komory)',
        'ar-KW' => 'arabčina (Kuvajt)',
        'ar-LB' => 'arabčina (Libanon)',
        'ar-LY' => 'arabčina (Líbya)',
        'ar-MA' => 'arabčina (Maroko)',
        'ar-MR' => 'arabčina (Mauritánia)',
        'ar-OM' => 'arabčina (Omán)',
        'ar-PS' => 'arabčina (Palestínske územia)',
        'ar-QA' => 'arabčina (Katar)',
        'ar-SA' => 'arabčina (Saudská Arábia)',
        'ar-SD' => 'arabčina (Sudán)',
        'ar-SO' => 'arabčina (Somálsko)',
        'ar-SS' => 'arabčina (Južný Sudán)',
        'ar-SY' => 'arabčina (Sýria)',
        'ar-TD' => 'arabčina (Čad)',
        'ar-TN' => 'arabčina (Tunisko)',
        'ar-YE' => 'arabčina (Jemen)',
        'as' => 'ásamčina',
        'as-IN' => 'ásamčina (India)',
        'asa' => 'asu',
        'asa-TZ' => 'asu (Tanzánia)',
        'ast' => 'astúrčina',
        'ast-ES' => 'astúrčina (Španielsko)',
        'az' => 'azerbajdžančina',
        'az-Cyrl' => 'azerbajdžančina (cyrilika)',
        'az-Cyrl-AZ' => 'azerbajdžančina (cyrilika, Azerbajdžan)',
        'az-Latn' => 'azerbajdžančina (latinka)',
        'az-Latn-AZ' => 'azerbajdžančina (latinka, Azerbajdžan)',
        'bas' => 'basa',
        'bas-CM' => 'basa (Kamerun)',
        'be' => 'bieloruština',
        'be-BY' => 'bieloruština (Bielorusko)',
        'bem' => 'bemba',
        'bem-ZM' => 'bemba (Zambia)',
        'bez' => 'bena',
        'bez-TZ' => 'bena (Tanzánia)',
        'bg' => 'bulharčina',
        'bg-BG' => 'bulharčina (Bulharsko)',
        'bm' => 'bambarčina',
        'bm-ML' => 'bambarčina (Mali)',
        'bn' => 'bengálčina',
        'bn-BD' => 'bengálčina (Bangladéš)',
        'bn-IN' => 'bengálčina (India)',
        'bo' => 'tibetčina',
        'bo-CN' => 'tibetčina (Čína)',
        'bo-IN' => 'tibetčina (India)',
        'br' => 'bretónčina',
        'br-FR' => 'bretónčina (Francúzsko)',
        'brx' => 'bodo',
        'brx-IN' => 'bodo (India)',
        'bs' => 'bosniačtina',
        'bs-Cyrl' => 'bosniačtina (cyrilika)',
        'bs-Cyrl-BA' => 'bosniačtina (cyrilika, Bosna a Hercegovina)',
        'bs-Latn' => 'bosniačtina (latinka)',
        'bs-Latn-BA' => 'bosniačtina (latinka, Bosna a Hercegovina)',
        'ca' => 'katalánčina',
        'ca-AD' => 'katalánčina (Andorra)',
        'ca-ES' => 'katalánčina (Španielsko)',
        'ca-FR' => 'katalánčina (Francúzsko)',
        'ca-IT' => 'katalánčina (Taliansko)',
        'ccp' => 'ccp',
        'ccp-BD' => 'ccp (Bangladéš)',
        'ccp-IN' => 'ccp (India)',
        'ce' => 'čečenčina',
        'ce-RU' => 'čečenčina (Rusko)',
        'ceb' => 'cebuánčina',
        'ceb-PH' => 'cebuánčina (Filipíny)',
        'cgg' => 'kiga',
        'cgg-UG' => 'kiga (Uganda)',
        'chr' => 'čerokí',
        'chr-US' => 'čerokí (Spojené štáty)',
        'ckb' => 'kurdčina (sorání)',
        'ckb-IQ' => 'kurdčina (sorání) (Irak)',
        'ckb-IR' => 'kurdčina (sorání) (Irán)',
        'cs' => 'čeština',
        'cs-CZ' => 'čeština (Česko)',
        'cy' => 'waleština',
        'cy-GB' => 'waleština (Spojené kráľovstvo)',
        'da' => 'dánčina',
        'da-DK' => 'dánčina (Dánsko)',
        'da-GL' => 'dánčina (Grónsko)',
        'dav' => 'taita',
        'dav-KE' => 'taita (Keňa)',
        'de' => 'nemčina',
        'de-AT' => 'nemčina (Rakúsko)',
        'de-BE' => 'nemčina (Belgicko)',
        'de-CH' => 'nemčina (Švajčiarsko)',
        'de-DE' => 'nemčina (Nemecko)',
        'de-IT' => 'nemčina (Taliansko)',
        'de-LI' => 'nemčina (Lichtenštajnsko)',
        'de-LU' => 'nemčina (Luxembursko)',
        'dje' => 'zarma',
        'dje-NE' => 'zarma (Niger)',
        'dsb' => 'dolnolužická srbčina',
        'dsb-DE' => 'dolnolužická srbčina (Nemecko)',
        'dua' => 'duala',
        'dua-CM' => 'duala (Kamerun)',
        'dyo' => 'jola-fonyi',
        'dyo-SN' => 'jola-fonyi (Senegal)',
        'dz' => 'dzongkha',
        'dz-BT' => 'dzongkha (Bhután)',
        'ebu' => 'embu',
        'ebu-KE' => 'embu (Keňa)',
        'ee' => 'eweština',
        'ee-GH' => 'eweština (Ghana)',
        'ee-TG' => 'eweština (Togo)',
        'el' => 'gréčtina',
        'el-CY' => 'gréčtina (Cyprus)',
        'el-GR' => 'gréčtina (Grécko)',
        'en' => 'angličtina',
        'en-001' => 'angličtina (svet)',
        'en-150' => 'angličtina (Európa)',
        'en-AE' => 'angličtina (Spojené arabské emiráty)',
        'en-AG' => 'angličtina (Antigua a Barbuda)',
        'en-AI' => 'angličtina (Anguilla)',
        'en-AS' => 'angličtina (Americká Samoa)',
        'en-AT' => 'angličtina (Rakúsko)',
        'en-AU' => 'angličtina (Austrália)',
        'en-BB' => 'angličtina (Barbados)',
        'en-BE' => 'angličtina (Belgicko)',
        'en-BI' => 'angličtina (Burundi)',
        'en-BM' => 'angličtina (Bermudy)',
        'en-BS' => 'angličtina (Bahamy)',
        'en-BW' => 'angličtina (Botswana)',
        'en-BZ' => 'angličtina (Belize)',
        'en-CA' => 'angličtina (Kanada)',
        'en-CC' => 'angličtina (Kokosové ostrovy)',
        'en-CH' => 'angličtina (Švajčiarsko)',
        'en-CK' => 'angličtina (Cookove ostrovy)',
        'en-CM' => 'angličtina (Kamerun)',
        'en-CX' => 'angličtina (Vianočný ostrov)',
        'en-CY' => 'angličtina (Cyprus)',
        'en-DE' => 'angličtina (Nemecko)',
        'en-DG' => 'angličtina (Diego Garcia)',
        'en-DK' => 'angličtina (Dánsko)',
        'en-DM' => 'angličtina (Dominika)',
        'en-ER' => 'angličtina (Eritrea)',
        'en-FI' => 'angličtina (Fínsko)',
        'en-FJ' => 'angličtina (Fidži)',
        'en-FK' => 'angličtina (Falklandy)',
        'en-FM' => 'angličtina (Mikronézia)',
        'en-GB' => 'angličtina (Spojené kráľovstvo)',
        'en-GD' => 'angličtina (Grenada)',
        'en-GG' => 'angličtina (Guernsey)',
        'en-GH' => 'angličtina (Ghana)',
        'en-GI' => 'angličtina (Gibraltár)',
        'en-GM' => 'angličtina (Gambia)',
        'en-GU' => 'angličtina (Guam)',
        'en-GY' => 'angličtina (Guyana)',
        'en-HK' => 'angličtina (Hongkong – OAO Číny)',
        'en-IE' => 'angličtina (Írsko)',
        'en-IL' => 'angličtina (Izrael)',
        'en-IM' => 'angličtina (Ostrov Man)',
        'en-IN' => 'angličtina (India)',
        'en-IO' => 'angličtina (Britské indickooceánske územie)',
        'en-JE' => 'angličtina (Jersey)',
        'en-JM' => 'angličtina (Jamajka)',
        'en-KE' => 'angličtina (Keňa)',
        'en-KI' => 'angličtina (Kiribati)',
        'en-KN' => 'angličtina (Svätý Krištof a Nevis)',
        'en-KY' => 'angličtina (Kajmanie ostrovy)',
        'en-LC' => 'angličtina (Svätá Lucia)',
        'en-LR' => 'angličtina (Libéria)',
        'en-LS' => 'angličtina (Lesotho)',
        'en-MG' => 'angličtina (Madagaskar)',
        'en-MH' => 'angličtina (Marshallove ostrovy)',
        'en-MO' => 'angličtina (Macao – OAO Číny)',
        'en-MP' => 'angličtina (Severné Mariány)',
        'en-MS' => 'angličtina (Montserrat)',
        'en-MT' => 'angličtina (Malta)',
        'en-MU' => 'angličtina (Maurícius)',
        'en-MW' => 'angličtina (Malawi)',
        'en-MY' => 'angličtina (Malajzia)',
        'en-NA' => 'angličtina (Namíbia)',
        'en-NF' => 'angličtina (Norfolk)',
        'en-NG' => 'angličtina (Nigéria)',
        'en-NL' => 'angličtina (Holandsko)',
        'en-NR' => 'angličtina (Nauru)',
        'en-NU' => 'angličtina (Niue)',
        'en-NZ' => 'angličtina (Nový Zéland)',
        'en-PG' => 'angličtina (Papua-Nová Guinea)',
        'en-PH' => 'angličtina (Filipíny)',
        'en-PK' => 'angličtina (Pakistan)',
        'en-PN' => 'angličtina (Pitcairnove ostrovy)',
        'en-PR' => 'angličtina (Portoriko)',
        'en-PW' => 'angličtina (Palau)',
        'en-RW' => 'angličtina (Rwanda)',
        'en-SB' => 'angličtina (Šalamúnove ostrovy)',
        'en-SC' => 'angličtina (Seychely)',
        'en-SD' => 'angličtina (Sudán)',
        'en-SE' => 'angličtina (Švédsko)',
        'en-SG' => 'angličtina (Singapur)',
        'en-SH' => 'angličtina (Svätá Helena)',
        'en-SI' => 'angličtina (Slovinsko)',
        'en-SL' => 'angličtina (Sierra Leone)',
        'en-SS' => 'angličtina (Južný Sudán)',
        'en-SX' => 'angličtina (Svätý Martin [hol.])',
        'en-SZ' => 'angličtina (Svazijsko)',
        'en-TC' => 'angličtina (Turks a Caicos)',
        'en-TK' => 'angličtina (Tokelau)',
        'en-TO' => 'angličtina (Tonga)',
        'en-TT' => 'angličtina (Trinidad a Tobago)',
        'en-TV' => 'angličtina (Tuvalu)',
        'en-TZ' => 'angličtina (Tanzánia)',
        'en-UG' => 'angličtina (Uganda)',
        'en-UM' => 'angličtina (Menšie odľahlé ostrovy USA)',
        'en-US' => 'angličtina (Spojené štáty)',
        'en-US-POSIX' => 'angličtina (Spojené štáty, POSIX)',
        'en-VC' => 'angličtina (Svätý Vincent a Grenadíny)',
        'en-VG' => 'angličtina (Britské Panenské ostrovy)',
        'en-VI' => 'angličtina (Americké Panenské ostrovy)',
        'en-VU' => 'angličtina (Vanuatu)',
        'en-WS' => 'angličtina (Samoa)',
        'en-ZA' => 'angličtina (Južná Afrika)',
        'en-ZM' => 'angličtina (Zambia)',
        'en-ZW' => 'angličtina (Zimbabwe)',
        'eo' => 'esperanto',
        'eo-001' => 'esperanto (svet)',
        'es' => 'španielčina',
        'es-419' => 'španielčina (Latinská Amerika)',
        'es-AR' => 'španielčina (Argentína)',
        'es-BO' => 'španielčina (Bolívia)',
        'es-BR' => 'španielčina (Brazília)',
        'es-BZ' => 'španielčina (Belize)',
        'es-CL' => 'španielčina (Čile)',
        'es-CO' => 'španielčina (Kolumbia)',
        'es-CR' => 'španielčina (Kostarika)',
        'es-CU' => 'španielčina (Kuba)',
        'es-DO' => 'španielčina (Dominikánska republika)',
        'es-EA' => 'španielčina (Ceuta a Melilla)',
        'es-EC' => 'španielčina (Ekvádor)',
        'es-ES' => 'španielčina (Španielsko)',
        'es-GQ' => 'španielčina (Rovníková Guinea)',
        'es-GT' => 'španielčina (Guatemala)',
        'es-HN' => 'španielčina (Honduras)',
        'es-IC' => 'španielčina (Kanárske ostrovy)',
        'es-MX' => 'španielčina (Mexiko)',
        'es-NI' => 'španielčina (Nikaragua)',
        'es-PA' => 'španielčina (Panama)',
        'es-PE' => 'španielčina (Peru)',
        'es-PH' => 'španielčina (Filipíny)',
        'es-PR' => 'španielčina (Portoriko)',
        'es-PY' => 'španielčina (Paraguaj)',
        'es-SV' => 'španielčina (Salvádor)',
        'es-US' => 'španielčina (Spojené štáty)',
        'es-UY' => 'španielčina (Uruguaj)',
        'es-VE' => 'španielčina (Venezuela)',
        'et' => 'estónčina',
        'et-EE' => 'estónčina (Estónsko)',
        'eu' => 'baskičtina',
        'eu-ES' => 'baskičtina (Španielsko)',
        'ewo' => 'ewondo',
        'ewo-CM' => 'ewondo (Kamerun)',
        'fa' => 'perzština',
        'fa-AF' => 'perzština (Afganistan)',
        'fa-IR' => 'perzština (Irán)',
        'ff' => 'fulbčina',
        'ff-Latn' => 'fulbčina (latinka)',
        'ff-Latn-BF' => 'fulbčina (latinka, Burkina Faso)',
        'ff-Latn-CM' => 'fulbčina (latinka, Kamerun)',
        'ff-Latn-GH' => 'fulbčina (latinka, Ghana)',
        'ff-Latn-GM' => 'fulbčina (latinka, Gambia)',
        'ff-Latn-GN' => 'fulbčina (latinka, Guinea)',
        'ff-Latn-GW' => 'fulbčina (latinka, Guinea-Bissau)',
        'ff-Latn-LR' => 'fulbčina (latinka, Libéria)',
        'ff-Latn-MR' => 'fulbčina (latinka, Mauritánia)',
        'ff-Latn-NE' => 'fulbčina (latinka, Niger)',
        'ff-Latn-NG' => 'fulbčina (latinka, Nigéria)',
        'ff-Latn-SL' => 'fulbčina (latinka, Sierra Leone)',
        'ff-Latn-SN' => 'fulbčina (latinka, Senegal)',
        'fi' => 'fínčina',
        'fi-FI' => 'fínčina (Fínsko)',
        'fil' => 'filipínčina',
        'fil-PH' => 'filipínčina (Filipíny)',
        'fo' => 'faerčina',
        'fo-DK' => 'faerčina (Dánsko)',
        'fo-FO' => 'faerčina (Faerské ostrovy)',
        'fr' => 'francúzština',
        'fr-BE' => 'francúzština (Belgicko)',
        'fr-BF' => 'francúzština (Burkina Faso)',
        'fr-BI' => 'francúzština (Burundi)',
        'fr-BJ' => 'francúzština (Benin)',
        'fr-BL' => 'francúzština (Svätý Bartolomej)',
        'fr-CA' => 'francúzština (Kanada)',
        'fr-CD' => 'francúzština (Konžská demokratická republika)',
        'fr-CF' => 'francúzština (Stredoafrická republika)',
        'fr-CG' => 'francúzština (Konžská republika)',
        'fr-CH' => 'francúzština (Švajčiarsko)',
        'fr-CI' => 'francúzština (Pobrežie Slonoviny)',
        'fr-CM' => 'francúzština (Kamerun)',
        'fr-DJ' => 'francúzština (Džibutsko)',
        'fr-DZ' => 'francúzština (Alžírsko)',
        'fr-FR' => 'francúzština (Francúzsko)',
        'fr-GA' => 'francúzština (Gabon)',
        'fr-GF' => 'francúzština (Francúzska Guyana)',
        'fr-GN' => 'francúzština (Guinea)',
        'fr-GP' => 'francúzština (Guadeloupe)',
        'fr-GQ' => 'francúzština (Rovníková Guinea)',
        'fr-HT' => 'francúzština (Haiti)',
        'fr-KM' => 'francúzština (Komory)',
        'fr-LU' => 'francúzština (Luxembursko)',
        'fr-MA' => 'francúzština (Maroko)',
        'fr-MC' => 'francúzština (Monako)',
        'fr-MF' => 'francúzština (Svätý Martin [fr.])',
        'fr-MG' => 'francúzština (Madagaskar)',
        'fr-ML' => 'francúzština (Mali)',
        'fr-MQ' => 'francúzština (Martinik)',
        'fr-MR' => 'francúzština (Mauritánia)',
        'fr-MU' => 'francúzština (Maurícius)',
        'fr-NC' => 'francúzština (Nová Kaledónia)',
        'fr-NE' => 'francúzština (Niger)',
        'fr-PF' => 'francúzština (Francúzska Polynézia)',
        'fr-PM' => 'francúzština (Saint Pierre a Miquelon)',
        'fr-RE' => 'francúzština (Réunion)',
        'fr-RW' => 'francúzština (Rwanda)',
        'fr-SC' => 'francúzština (Seychely)',
        'fr-SN' => 'francúzština (Senegal)',
        'fr-SY' => 'francúzština (Sýria)',
        'fr-TD' => 'francúzština (Čad)',
        'fr-TG' => 'francúzština (Togo)',
        'fr-TN' => 'francúzština (Tunisko)',
        'fr-VU' => 'francúzština (Vanuatu)',
        'fr-WF' => 'francúzština (Wallis a Futuna)',
        'fr-YT' => 'francúzština (Mayotte)',
        'fur' => 'friulčina',
        'fur-IT' => 'friulčina (Taliansko)',
        'fy' => 'západná frízština',
        'fy-NL' => 'západná frízština (Holandsko)',
        'ga' => 'írčina',
        'ga-IE' => 'írčina (Írsko)',
        'gd' => 'škótska gaelčina',
        'gd-GB' => 'škótska gaelčina (Spojené kráľovstvo)',
        'gl' => 'galícijčina',
        'gl-ES' => 'galícijčina (Španielsko)',
        'gsw' => 'nemčina (švajčiarska)',
        'gsw-CH' => 'nemčina (švajčiarska) (Švajčiarsko)',
        'gsw-FR' => 'nemčina (švajčiarska) (Francúzsko)',
        'gsw-LI' => 'nemčina (švajčiarska) (Lichtenštajnsko)',
        'gu' => 'gudžarátčina',
        'gu-IN' => 'gudžarátčina (India)',
        'guz' => 'gusii',
        'guz-KE' => 'gusii (Keňa)',
        'gv' => 'mančina',
        'gv-IM' => 'mančina (Ostrov Man)',
        'ha' => 'hauština',
        'ha-GH' => 'hauština (Ghana)',
        'ha-NE' => 'hauština (Niger)',
        'ha-NG' => 'hauština (Nigéria)',
        'haw' => 'havajčina',
        'haw-US' => 'havajčina (Spojené štáty)',
        'he' => 'hebrejčina',
        'he-IL' => 'hebrejčina (Izrael)',
        'hi' => 'hindčina',
        'hi-IN' => 'hindčina (India)',
        'hr' => 'chorvátčina',
        'hr-BA' => 'chorvátčina (Bosna a Hercegovina)',
        'hr-HR' => 'chorvátčina (Chorvátsko)',
        'hsb' => 'hornolužická srbčina',
        'hsb-DE' => 'hornolužická srbčina (Nemecko)',
        'hu' => 'maďarčina',
        'hu-HU' => 'maďarčina (Maďarsko)',
        'hy' => 'arménčina',
        'hy-AM' => 'arménčina (Arménsko)',
        'ia' => 'interlingua',
        'ia-001' => 'interlingua (svet)',
        'id' => 'indonézština',
        'id-ID' => 'indonézština (Indonézia)',
        'ig' => 'igboština',
        'ig-NG' => 'igboština (Nigéria)',
        'ii' => 's’čchuanská iovčina',
        'ii-CN' => 's’čchuanská iovčina (Čína)',
        'is' => 'islandčina',
        'is-IS' => 'islandčina (Island)',
        'it' => 'taliančina',
        'it-CH' => 'taliančina (Švajčiarsko)',
        'it-IT' => 'taliančina (Taliansko)',
        'it-SM' => 'taliančina (San Maríno)',
        'it-VA' => 'taliančina (Vatikán)',
        'ja' => 'japončina',
        'ja-JP' => 'japončina (Japonsko)',
        'jgo' => 'ngomba',
        'jgo-CM' => 'ngomba (Kamerun)',
        'jmc' => 'mašame',
        'jmc-TZ' => 'mašame (Tanzánia)',
        'jv' => 'jávčina',
        'jv-ID' => 'jávčina (Indonézia)',
        'ka' => 'gruzínčina',
        'ka-GE' => 'gruzínčina (Gruzínsko)',
        'kab' => 'kabylčina',
        'kab-DZ' => 'kabylčina (Alžírsko)',
        'kam' => 'kamba',
        'kam-KE' => 'kamba (Keňa)',
        'kde' => 'makonde',
        'kde-TZ' => 'makonde (Tanzánia)',
        'kea' => 'kapverdčina',
        'kea-CV' => 'kapverdčina (Kapverdy)',
        'khq' => 'západná songhajčina',
        'khq-ML' => 'západná songhajčina (Mali)',
        'ki' => 'kikujčina',
        'ki-KE' => 'kikujčina (Keňa)',
        'kk' => 'kazaština',
        'kk-KZ' => 'kazaština (Kazachstan)',
        'kkj' => 'kako',
        'kkj-CM' => 'kako (Kamerun)',
        'kl' => 'grónčina',
        'kl-GL' => 'grónčina (Grónsko)',
        'kln' => 'kalendžin',
        'kln-KE' => 'kalendžin (Keňa)',
        'km' => 'khmérčina',
        'km-KH' => 'khmérčina (Kambodža)',
        'kn' => 'kannadčina',
        'kn-IN' => 'kannadčina (India)',
        'ko' => 'kórejčina',
        'ko-KP' => 'kórejčina (Severná Kórea)',
        'ko-KR' => 'kórejčina (Južná Kórea)',
        'kok' => 'konkánčina',
        'kok-IN' => 'konkánčina (India)',
        'ks' => 'kašmírčina',
        'ks-IN' => 'kašmírčina (India)',
        'ksb' => 'šambala',
        'ksb-TZ' => 'šambala (Tanzánia)',
        'ksf' => 'bafia',
        'ksf-CM' => 'bafia (Kamerun)',
        'ksh' => 'kolínčina',
        'ksh-DE' => 'kolínčina (Nemecko)',
        'ku' => 'kurdčina',
        'ku-TR' => 'kurdčina (Turecko)',
        'kw' => 'kornčina',
        'kw-GB' => 'kornčina (Spojené kráľovstvo)',
        'ky' => 'kirgizština',
        'ky-KG' => 'kirgizština (Kirgizsko)',
        'lag' => 'langi',
        'lag-TZ' => 'langi (Tanzánia)',
        'lb' => 'luxemburčina',
        'lb-LU' => 'luxemburčina (Luxembursko)',
        'lg' => 'gandčina',
        'lg-UG' => 'gandčina (Uganda)',
        'lkt' => 'lakotčina',
        'lkt-US' => 'lakotčina (Spojené štáty)',
        'ln' => 'lingalčina',
        'ln-AO' => 'lingalčina (Angola)',
        'ln-CD' => 'lingalčina (Konžská demokratická republika)',
        'ln-CF' => 'lingalčina (Stredoafrická republika)',
        'ln-CG' => 'lingalčina (Konžská republika)',
        'lo' => 'laoština',
        'lo-LA' => 'laoština (Laos)',
        'lrc' => 'severné luri',
        'lrc-IQ' => 'severné luri (Irak)',
        'lrc-IR' => 'severné luri (Irán)',
        'lt' => 'litovčina',
        'lt-LT' => 'litovčina (Litva)',
        'lu' => 'lubčina (katanžská)',
        'lu-CD' => 'lubčina (katanžská) (Konžská demokratická republika)',
        'luo' => 'luo',
        'luo-KE' => 'luo (Keňa)',
        'luy' => 'luhja',
        'luy-KE' => 'luhja (Keňa)',
        'lv' => 'lotyština',
        'lv-LV' => 'lotyština (Lotyšsko)',
        'mas' => 'masajčina',
        'mas-KE' => 'masajčina (Keňa)',
        'mas-TZ' => 'masajčina (Tanzánia)',
        'mer' => 'meru',
        'mer-KE' => 'meru (Keňa)',
        'mfe' => 'maurícijská kreolčina',
        'mfe-MU' => 'maurícijská kreolčina (Maurícius)',
        'mg' => 'malgaština',
        'mg-MG' => 'malgaština (Madagaskar)',
        'mgh' => 'makua-meetto',
        'mgh-MZ' => 'makua-meetto (Mozambik)',
        'mgo' => 'meta’',
        'mgo-CM' => 'meta’ (Kamerun)',
        'mi' => 'maorijčina',
        'mi-NZ' => 'maorijčina (Nový Zéland)',
        'mk' => 'macedónčina',
        'mk-MK' => 'macedónčina (Severné Macedónsko)',
        'ml' => 'malajálamčina',
        'ml-IN' => 'malajálamčina (India)',
        'mn' => 'mongolčina',
        'mn-MN' => 'mongolčina (Mongolsko)',
        'mr' => 'maráthčina',
        'mr-IN' => 'maráthčina (India)',
        'ms' => 'malajčina',
        'ms-BN' => 'malajčina (Brunej)',
        'ms-MY' => 'malajčina (Malajzia)',
        'ms-SG' => 'malajčina (Singapur)',
        'mt' => 'maltčina',
        'mt-MT' => 'maltčina (Malta)',
        'mua' => 'mundang',
        'mua-CM' => 'mundang (Kamerun)',
        'my' => 'barmčina',
        'my-MM' => 'barmčina (Mjanmarsko)',
        'mzn' => 'mázandaránčina',
        'mzn-IR' => 'mázandaránčina (Irán)',
        'naq' => 'nama',
        'naq-NA' => 'nama (Namíbia)',
        'nb' => 'nórčina (bokmal)',
        'nb-NO' => 'nórčina (bokmal) (Nórsko)',
        'nb-SJ' => 'nórčina (bokmal) (Svalbard a Jan Mayen)',
        'nd' => 'ndebelčina (severná)',
        'nd-ZW' => 'ndebelčina (severná) (Zimbabwe)',
        'nds' => 'dolná nemčina',
        'nds-DE' => 'dolná nemčina (Nemecko)',
        'nds-NL' => 'dolná nemčina (Holandsko)',
        'ne' => 'nepálčina',
        'ne-IN' => 'nepálčina (India)',
        'ne-NP' => 'nepálčina (Nepál)',
        'nl' => 'holandčina',
        'nl-AW' => 'holandčina (Aruba)',
        'nl-BE' => 'holandčina (Belgicko)',
        'nl-BQ' => 'holandčina (Karibské Holandsko)',
        'nl-CW' => 'holandčina (Curaçao)',
        'nl-NL' => 'holandčina (Holandsko)',
        'nl-SR' => 'holandčina (Surinam)',
        'nl-SX' => 'holandčina (Svätý Martin [hol.])',
        'nmg' => 'kwasio',
        'nmg-CM' => 'kwasio (Kamerun)',
        'nn' => 'nórčina (nynorsk)',
        'nn-NO' => 'nórčina (nynorsk) (Nórsko)',
        'nnh' => 'ngiemboon',
        'nnh-CM' => 'ngiemboon (Kamerun)',
        'nus' => 'nuer',
        'nus-SS' => 'nuer (Južný Sudán)',
        'nyn' => 'ňankole',
        'nyn-UG' => 'ňankole (Uganda)',
        'om' => 'oromčina',
        'om-ET' => 'oromčina (Etiópia)',
        'om-KE' => 'oromčina (Keňa)',
        'or' => 'uríjčina',
        'or-IN' => 'uríjčina (India)',
        'os' => 'osetčina',
        'os-GE' => 'osetčina (Gruzínsko)',
        'os-RU' => 'osetčina (Rusko)',
        'pa' => 'pandžábčina',
        'pa-Arab' => 'pandžábčina (arabské)',
        'pa-Arab-PK' => 'pandžábčina (arabské, Pakistan)',
        'pa-Guru' => 'pandžábčina (gurmukhi)',
        'pa-Guru-IN' => 'pandžábčina (gurmukhi, India)',
        'pl' => 'poľština',
        'pl-PL' => 'poľština (Poľsko)',
        'ps' => 'paštčina',
        'ps-AF' => 'paštčina (Afganistan)',
        'ps-PK' => 'paštčina (Pakistan)',
        'pt' => 'portugalčina',
        'pt-AO' => 'portugalčina (Angola)',
        'pt-BR' => 'portugalčina (Brazília)',
        'pt-CH' => 'portugalčina (Švajčiarsko)',
        'pt-CV' => 'portugalčina (Kapverdy)',
        'pt-GQ' => 'portugalčina (Rovníková Guinea)',
        'pt-GW' => 'portugalčina (Guinea-Bissau)',
        'pt-LU' => 'portugalčina (Luxembursko)',
        'pt-MO' => 'portugalčina (Macao – OAO Číny)',
        'pt-MZ' => 'portugalčina (Mozambik)',
        'pt-PT' => 'portugalčina (Portugalsko)',
        'pt-ST' => 'portugalčina (Svätý Tomáš a Princov ostrov)',
        'pt-TL' => 'portugalčina (Východný Timor)',
        'qu' => 'kečuánčina',
        'qu-BO' => 'kečuánčina (Bolívia)',
        'qu-EC' => 'kečuánčina (Ekvádor)',
        'qu-PE' => 'kečuánčina (Peru)',
        'rm' => 'rétorománčina',
        'rm-CH' => 'rétorománčina (Švajčiarsko)',
        'rn' => 'rundčina',
        'rn-BI' => 'rundčina (Burundi)',
        'ro' => 'rumunčina',
        'ro-MD' => 'rumunčina (Moldavsko)',
        'ro-RO' => 'rumunčina (Rumunsko)',
        'rof' => 'rombo',
        'rof-TZ' => 'rombo (Tanzánia)',
        'ru' => 'ruština',
        'ru-BY' => 'ruština (Bielorusko)',
        'ru-KG' => 'ruština (Kirgizsko)',
        'ru-KZ' => 'ruština (Kazachstan)',
        'ru-MD' => 'ruština (Moldavsko)',
        'ru-RU' => 'ruština (Rusko)',
        'ru-UA' => 'ruština (Ukrajina)',
        'rw' => 'rwandčina',
        'rw-RW' => 'rwandčina (Rwanda)',
        'rwk' => 'rwa',
        'rwk-TZ' => 'rwa (Tanzánia)',
        'sah' => 'jakutčina',
        'sah-RU' => 'jakutčina (Rusko)',
        'saq' => 'samburu',
        'saq-KE' => 'samburu (Keňa)',
        'sbp' => 'sangu',
        'sbp-TZ' => 'sangu (Tanzánia)',
        'sd' => 'sindhčina',
        'sd-PK' => 'sindhčina (Pakistan)',
        'se' => 'saamčina (severná)',
        'se-FI' => 'saamčina (severná) (Fínsko)',
        'se-NO' => 'saamčina (severná) (Nórsko)',
        'se-SE' => 'saamčina (severná) (Švédsko)',
        'seh' => 'sena',
        'seh-MZ' => 'sena (Mozambik)',
        'ses' => 'koyraboro senni',
        'ses-ML' => 'koyraboro senni (Mali)',
        'sg' => 'sango',
        'sg-CF' => 'sango (Stredoafrická republika)',
        'shi' => 'tachelhit',
        'shi-Latn' => 'tachelhit (latinka)',
        'shi-Latn-MA' => 'tachelhit (latinka, Maroko)',
        'shi-Tfng' => 'tachelhit (Tfng)',
        'shi-Tfng-MA' => 'tachelhit (Tfng, Maroko)',
        'si' => 'sinhalčina',
        'si-LK' => 'sinhalčina (Srí Lanka)',
        'sk' => 'slovenčina',
        'sk-SK' => 'slovenčina (Slovensko)',
        'sl' => 'slovinčina',
        'sl-SI' => 'slovinčina (Slovinsko)',
        'smn' => 'saamčina (inarijská)',
        'smn-FI' => 'saamčina (inarijská) (Fínsko)',
        'sn' => 'šončina',
        'sn-ZW' => 'šončina (Zimbabwe)',
        'so' => 'somálčina',
        'so-DJ' => 'somálčina (Džibutsko)',
        'so-ET' => 'somálčina (Etiópia)',
        'so-KE' => 'somálčina (Keňa)',
        'so-SO' => 'somálčina (Somálsko)',
        'sq' => 'albánčina',
        'sq-AL' => 'albánčina (Albánsko)',
        'sq-MK' => 'albánčina (Severné Macedónsko)',
        'sq-XK' => 'albánčina (Kosovo)',
        'sr' => 'srbčina',
        'sr-Cyrl' => 'srbčina (cyrilika)',
        'sr-Cyrl-BA' => 'srbčina (cyrilika, Bosna a Hercegovina)',
        'sr-Cyrl-ME' => 'srbčina (cyrilika, Čierna Hora)',
        'sr-Cyrl-RS' => 'srbčina (cyrilika, Srbsko)',
        'sr-Cyrl-XK' => 'srbčina (cyrilika, Kosovo)',
        'sr-Latn' => 'srbčina (latinka)',
        'sr-Latn-BA' => 'srbčina (latinka, Bosna a Hercegovina)',
        'sr-Latn-ME' => 'srbčina (latinka, Čierna Hora)',
        'sr-Latn-RS' => 'srbčina (latinka, Srbsko)',
        'sr-Latn-XK' => 'srbčina (latinka, Kosovo)',
        'sv' => 'švédčina',
        'sv-AX' => 'švédčina (Alandy)',
        'sv-FI' => 'švédčina (Fínsko)',
        'sv-SE' => 'švédčina (Švédsko)',
        'sw' => 'swahilčina',
        'sw-CD' => 'swahilčina (Konžská demokratická republika)',
        'sw-KE' => 'swahilčina (Keňa)',
        'sw-TZ' => 'swahilčina (Tanzánia)',
        'sw-UG' => 'swahilčina (Uganda)',
        'ta' => 'tamilčina',
        'ta-IN' => 'tamilčina (India)',
        'ta-LK' => 'tamilčina (Srí Lanka)',
        'ta-MY' => 'tamilčina (Malajzia)',
        'ta-SG' => 'tamilčina (Singapur)',
        'te' => 'telugčina',
        'te-IN' => 'telugčina (India)',
        'teo' => 'teso',
        'teo-KE' => 'teso (Keňa)',
        'teo-UG' => 'teso (Uganda)',
        'tg' => 'tadžičtina',
        'tg-TJ' => 'tadžičtina (Tadžikistan)',
        'th' => 'thajčina',
        'th-TH' => 'thajčina (Thajsko)',
        'ti' => 'tigriňa',
        'ti-ER' => 'tigriňa (Eritrea)',
        'ti-ET' => 'tigriňa (Etiópia)',
        'tk' => 'turkménčina',
        'tk-TM' => 'turkménčina (Turkménsko)',
        'to' => 'tongčina',
        'to-TO' => 'tongčina (Tonga)',
        'tr' => 'turečtina',
        'tr-CY' => 'turečtina (Cyprus)',
        'tr-TR' => 'turečtina (Turecko)',
        'tt' => 'tatárčina',
        'tt-RU' => 'tatárčina (Rusko)',
        'twq' => 'tasawaq',
        'twq-NE' => 'tasawaq (Niger)',
        'tzm' => 'tuaregčina (stredomarocká)',
        'tzm-MA' => 'tuaregčina (stredomarocká) (Maroko)',
        'ug' => 'ujgurčina',
        'ug-CN' => 'ujgurčina (Čína)',
        'uk' => 'ukrajinčina',
        'uk-UA' => 'ukrajinčina (Ukrajina)',
        'ur' => 'urdčina',
        'ur-IN' => 'urdčina (India)',
        'ur-PK' => 'urdčina (Pakistan)',
        'uz' => 'uzbečtina',
        'uz-Arab' => 'uzbečtina (arabské)',
        'uz-Arab-AF' => 'uzbečtina (arabské, Afganistan)',
        'uz-Cyrl' => 'uzbečtina (cyrilika)',
        'uz-Cyrl-UZ' => 'uzbečtina (cyrilika, Uzbekistan)',
        'uz-Latn' => 'uzbečtina (latinka)',
        'uz-Latn-UZ' => 'uzbečtina (latinka, Uzbekistan)',
        'vai' => 'vai',
        'vai-Latn' => 'vai (latinka)',
        'vai-Latn-LR' => 'vai (latinka, Libéria)',
        'vai-Vaii' => 'vai (Vaii)',
        'vai-Vaii-LR' => 'vai (Vaii, Libéria)',
        'vi' => 'vietnamčina',
        'vi-VN' => 'vietnamčina (Vietnam)',
        'vun' => 'vunjo',
        'vun-TZ' => 'vunjo (Tanzánia)',
        'wae' => 'walserčina',
        'wae-CH' => 'walserčina (Švajčiarsko)',
        'wo' => 'wolofčina',
        'wo-SN' => 'wolofčina (Senegal)',
        'xh' => 'xhoština',
        'xh-ZA' => 'xhoština (Južná Afrika)',
        'xog' => 'soga',
        'xog-UG' => 'soga (Uganda)',
        'yav' => 'jangben',
        'yav-CM' => 'jangben (Kamerun)',
        'yi' => 'jidiš',
        'yi-001' => 'jidiš (svet)',
        'yo' => 'jorubčina',
        'yo-BJ' => 'jorubčina (Benin)',
        'yo-NG' => 'jorubčina (Nigéria)',
        'yue' => 'kantončina',
        'yue-Hans' => 'kantončina (zjednodušené)',
        'yue-Hans-CN' => 'kantončina (zjednodušené, Čína)',
        'yue-Hant' => 'kantončina (tradičné)',
        'yue-Hant-HK' => 'kantončina (tradičné, Hongkong – OAO Číny)',
        'zgh' => 'tuaregčina (štandardná marocká)',
        'zgh-MA' => 'tuaregčina (štandardná marocká) (Maroko)',
        'zh' => 'čínština',
        'zh-Hans' => 'čínština (zjednodušené)',
        'zh-Hans-CN' => 'čínština (zjednodušené, Čína)',
        'zh-Hans-HK' => 'čínština (zjednodušené, Hongkong – OAO Číny)',
        'zh-Hans-MO' => 'čínština (zjednodušené, Macao – OAO Číny)',
        'zh-Hans-SG' => 'čínština (zjednodušené, Singapur)',
        'zh-Hant' => 'čínština (tradičné)',
        'zh-Hant-HK' => 'čínština (tradičné, Hongkong – OAO Číny)',
        'zh-Hant-MO' => 'čínština (tradičné, Macao – OAO Číny)',
        'zh-Hant-TW' => 'čínština (tradičné, Taiwan)',
        'zu' => 'zuluština',
        'zu-ZA' => 'zuluština (Južná Afrika)',
    ],
];
